VAQADM50 ;ALB/JRP - GENERATE PDX TRANSMISSIONS;10-MAR-93
 ;;1.5;PATIENT DATA EXCHANGE;**5,35**;NOV 17, 1993
START ;START RESPONSE TIME MONITORING (TIME TO BUILD/SEND COMPLETE TRANSMISSION)
 I ($D(XRTL)) D T0^%ZOSV
 Q
 ;
STOP ;STOP RESPONSE TIME MONITORING
 I ($D(XRT0)) S XRTN=$T(+0) D T1^%ZOSV K XRTN,XRT0
 Q
 ;
GENXMIT ;MAIN ENTRY POINT FOR GENERATING PDX TRANSMISSIONS
 ;INPUT  : VAQTRN - Array of pointers to VAQ - TRANSACTION file
 ;OUTPUT : None
 ;NOTE   : This module builds/transmits the PDX transmissions, it
 ;         does not prompt the user for information.  Messages
 ;         stating any errors that may occur will be sent to the
 ;         current user & the mail group 'VAQ PDX ERRORS'
 ;
 ;CHECK INPUT
 Q:('$D(VAQTRN))
 Q:('$O(VAQTRN("")))
 ;DECLARE VARIABLES
 N ARRAY1,ARRAY2,ARRAY3,ARRAY4,ARRAY5,TMP,XMZ,XMY,TYPE
 N TMPARR,XMDUN,DOMAIN,TRANS,SITE,X,ERRNUM,VERSION,LINE,XMCHAN
 N DEFENCON,DEFTYPE
 S ARRAY1="^TMP(""VAQ-XMIT"","_$J_",""BLD"")"
 S ARRAY2="^TMP(""VAQ-XMIT"","_$J_",""DOM"")"
 S ARRAY3="^TMP(""VAQ-XMIT"","_$J_",""ERR"")"
 S ARRAY4="^TMP(""VAQ-XMIT"","_$J_",""V1.0"")"
 S ARRAY5="^TMP(""VAQ-XMIT"","_$J_",""XTRCT"")"
 S XMCHAN=1
 K @ARRAY1,@ARRAY2,@ARRAY3,@ARRAY4,@ARRAY5
 ;GET SITE NAME FROM PARAMETER FILE
 S TMP=+$O(^VAT(394.81,0))
 S SITE=+$G(^VAT(394.81,TMP,0))
 S TMP=$P($G(^DIC(4,SITE,0)),"^",1)
 I (TMP="") S TMP=$P($$SITE^VASITE,"^",2) S:(TMP=-1) TMP="UNKNOWN"
 S SITE=TMP
 ;DETERMINE DEFAULT ENCRYPTION VALUES
 S DEFENCON=0
 S DEFTYPE=$$NCRYPTON^VAQUTL2(2)
 S:(DEFTYPE'="") DEFENCON=1
 ;"COMBINE" TRANSMISSIONS TO SAME DOMAIN & SCREEN OUT V1.0 MESSAGES
 S TRANS=""
 F  S TRANS=$O(VAQTRN(TRANS)) Q:('TRANS)  D
 .I ('$D(^VAT(394.61,TRANS,0))) S @ARRAY3@(TRANS,0)="Transaction does not exist" Q
 .;GET VERSION NUMBER
 .S VERSION=+$P($G(^VAT(394.61,TRANS,0)),"^",7)
 .;GET MESSAGE TYPE
 .S TMP=$$STATYPE^VAQCON1(TRANS)
 .I ($P(TMP,"^",1)="-1") D  Q
 ..S @ARRAY3@(TRANS,0)="Could not determine message type"
 ..S @ARRAY3@(TRANS,1)=$P(TMP,"^",2)
 .S TYPE=$P(TMP,"^",2)
 .S:(TYPE="ACK") TYPE=$P(TMP,"^",1)
 .;GET DOMAIN
 .S DOMAIN=""
 .S:((TYPE="VAQ-UNACK")!(TYPE="REQ")) DOMAIN=$P($G(^VAT(394.61,TRANS,"ATHR2")),"^",2)
 .S:((TYPE="RES")!(TYPE="UNS")!(TYPE="VAQ-RQACK")) DOMAIN=$P($G(^VAT(394.61,TRANS,"RQST2")),"^",2)
 .I (TYPE="REC") S @ARRAY3@(TRANS,0)="Can not transmit a transaction that is being received" Q
 .I (DOMAIN="") S @ARRAY3@(TRANS,0)="Transaction did not contain a domain to transmit message to" Q
 .I $$CLOSDOM^VAQUTL97(TRANS,DOMAIN) D  Q  ; Don't send transactions to closed domains.  (And mark such transactions for purging.)
 . .S @ARRAY3@(TRANS,0)="Domain is closed: "_DOMAIN
 .;SCREEN OUT VERSION 1.0 MESSAGE
 .I (VERSION=1) S @ARRAY4@(TRANS)="" Q
 .;COMBINE 1.5 MESSAGES TO SAME DOMAIN
 .S TMP=$P(DOMAIN,".",1)
 .S @ARRAY1@(TMP,TRANS)=""
 .S @ARRAY2@(TMP)=DOMAIN
 .;FILE ENCRYPTION VALUES FOR REQUESTS & UNSOLICITED PDXS
 .I ((TYPE="REQ")!(TYPE="UNS")) D
 ..S TMP=$$FILEINFO^VAQFILE(394.61,TRANS,40,$S(DEFENCON:"YES",1:"NO"))
 ..Q:('DEFENCON)
 ..S TMP=$$FILEINFO^VAQFILE(394.61,TRANS,41,DEFTYPE)
 ;GENERATE & SEND VERSION 1.0 MESSAGES
 S TRANS=""
 F  S TRANS=$O(@ARRAY4@(TRANS)) Q:(TRANS="")  D START D  D STOP
 .S TMP=$$SEND10^VAQCON93(TRANS)
 .I (+TMP) D
 ..S @ARRAY3@(TRANS,0)="Error occurred while building transmission(1)"
 ..S @ARRAY3@(TRANS,1)=$P(TMP,"^",2)
 ;GENERATE & SEND VERSION 1.0 MESSAGES
 D XMIT15^VAQADM51
 ;SEND ERROR MESSAGES (IF NEEDED)
 I (+$O(@ARRAY3@(""))) D
 .D ERR2USR^VAQBUL01
 .D ERR2IRM^VAQBUL01
 K @ARRAY1,@ARRAY2,@ARRAY3,@ARRAY4,@ARRAY5
 S:($D(ZTQUEUED)) ZTREQ="@"
 Q
